<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(e($page['props']['seo']['meta_title'] ?? $page['props']['appName'] ?? config('app.name', 'Mine Invest App'))); ?></title>

    <?php
        $favicon = $page['props']['faviconUrl'] ?? asset('favicon.ico');
    ?>
    <link rel="icon" href="<?php echo e($favicon); ?>">
    <link rel="shortcut icon" href="<?php echo e($favicon); ?>">

    <?php
        $description = $page['props']['seo']['meta_description'] ?? '';
        $keywords = $page['props']['seo']['meta_keywords'] ?? '';
        $ogTitle = $page['props']['seo']['og_title'] ?? $page['props']['seo']['meta_title'] ?? $page['props']['appName'] ?? config('app.name');
        $ogDescription = $page['props']['seo']['og_description'] ?? $description;
        $ogImage = $page['props']['seo']['og_image_url'] ?? null;
    ?>

    <link rel="canonical" href="<?php echo e(url()->current()); ?>">
    <?php if($description): ?>
        <meta name="description" content="<?php echo e(e($description)); ?>">
    <?php endif; ?>
    <?php if($keywords): ?>
        <meta name="keywords" content="<?php echo e(e($keywords)); ?>">
    <?php endif; ?>

    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(e($page['props']['appName'] ?? config('app.name'))); ?>">
    <meta property="og:title" content="<?php echo e(e($ogTitle)); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <?php if($ogDescription): ?>
        <meta property="og:description" content="<?php echo e(e($ogDescription)); ?>">
    <?php endif; ?>
    <?php if($ogImage): ?>
        <meta property="og:image" content="<?php echo e(e($ogImage)); ?>">
        <meta property="og:image:alt" content="<?php echo e(e($ogTitle)); ?>">
    <?php endif; ?>

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e(e($ogTitle)); ?>">
    <?php if($ogDescription): ?>
        <meta name="twitter:description" content="<?php echo e(e($ogDescription)); ?>">
    <?php endif; ?>
    <?php if($ogImage): ?>
        <meta name="twitter:image" content="<?php echo e(e($ogImage)); ?>">
    <?php endif; ?>

    <meta name="theme-color" content="#ffffff">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="preload" href="<?php echo e(asset('css/all.min.css')); ?>" as="style">
    <?php if(!empty($page['props']['seo']['google_analytics'])): ?>
        <link rel="preconnect" href="https://www.googletagmanager.com">
        <link rel="dns-prefetch" href="https://www.googletagmanager.com">
    <?php endif; ?>

    <link rel="stylesheet" href="<?php echo e(asset('css/all.min.css')); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>

    <?php if(!empty($page['props']['seo']['google_analytics'])): ?>
        <?php $gaId = e($page['props']['seo']['google_analytics']); ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($gaId); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '<?php echo e($gaId); ?>', {
                page_title: '<?php echo e(e($ogTitle)); ?>',
                page_location: '<?php echo e(url()->current()); ?>'
            });
        </script>
    <?php endif; ?>

    <?php if(!empty($page['props']['tawk']['property_id']) && !empty($page['props']['tawk']['widget_id'])): ?>
        <?php
            $tawkPropertyId = e($page['props']['tawk']['property_id']);
            $tawkWidgetId = e($page['props']['tawk']['widget_id']);
        ?>
        <script type="text/javascript">
            var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
            (function(){
                var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
                s1.async=true;
                s1.src='https://embed.tawk.to/<?php echo e($tawkPropertyId); ?>/<?php echo e($tawkWidgetId); ?>';
                s1.charset='UTF-8';
                s1.setAttribute('crossorigin','*');
                s0.parentNode.insertBefore(s1,s0);
            })();
        </script>
    <?php endif; ?>
</head>
<body class="font-sans antialiased">
<?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
</body>
</html>
<?php /**PATH /Users/sabbir/Sites/hyip-investment/resources/views/app.blade.php ENDPATH**/ ?>