<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\InvestmentPlan;
use Illuminate\Support\Str;

class InvestmentPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter Plan',
                'slug' => 'starter-plan',
                'description' => 'Perfect for beginners who want to start their investment journey with minimal risk. This plan offers steady returns with maximum security and flexibility.',
                'features' => [
                    'Daily profit withdrawal',
                    'No hidden fees',
                    'Instant deposit confirmation',
                ],
                'min_amount' => 100.00,
                'max_amount' => 1000.00,
                'interest_rate' => 1.2,
                'interest_type' => 'fixed',
                'return_type' => 'daily',
                'duration_days' => 30,
                'principal_return' => 'yes',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 10.00,
                'partial_withdrawal_allowed' => true,
                'early_withdrawal_fee' => 2.00,
                'max_investors' => 1000,
                'total_cap' => 500000.00,
                'risk_level' => 'low',
                'ai_recommendation_score' => [
                    'stability_score' => '9.2',
                    'growth_potential' => '7.5',
                    'liquidity_rating' => '8.8'
                ],
                'success_rate' => 98.50,
                'color_scheme' => '#10b981',
                'badges' => ['Beginner Friendly', 'Low Risk'],
                'sort_order' => 1,
                'featured' => false,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Growth Plan',
                'slug' => 'growth-plan',
                'description' => 'Designed for investors seeking balanced growth with moderate risk. Ideal for those who want higher returns while maintaining reasonable security.',
                'features' => [
                    'Higher daily returns',
                    'Compound interest option',
                    'Priority customer support',
                ],
                'min_amount' => 1000.00,
                'max_amount' => 10000.00,
                'interest_rate' => 2.5,
                'interest_type' => 'compound',
                'return_type' => 'daily',
                'duration_days' => 60,
                'principal_return' => 'after_maturity',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 25.00,
                'partial_withdrawal_allowed' => true,
                'early_withdrawal_fee' => 5.00,
                'max_investors' => 500,
                'total_cap' => 2000000.00,
                'risk_level' => 'medium',
                'ai_recommendation_score' => [
                    'stability_score' => '8.1',
                    'growth_potential' => '9.0',
                    'liquidity_rating' => '7.5'
                ],
                'success_rate' => 95.20,
                'color_scheme' => '#3b82f6',
                'badges' => ['Popular', 'Balanced Growth'],
                'sort_order' => 2,
                'featured' => true,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Premium Plan',
                'slug' => 'premium-plan',
                'description' => 'Our most aggressive investment plan for experienced investors. Maximum returns for those willing to take calculated risks.',
                'features' => [
                    'Maximum profit potential',
                    'VIP customer service',
                ],
                'min_amount' => 10000.00,
                'max_amount' => 100000.00,
                'interest_rate' => 4.0,
                'interest_type' => 'compound',
                'return_type' => 'daily',
                'duration_days' => 90,
                'principal_return' => 'after_maturity',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 50.00,
                'partial_withdrawal_allowed' => false,
                'early_withdrawal_fee' => 10.00,
                'max_investors' => 100,
                'total_cap' => 5000000.00,
                'risk_level' => 'high',
                'ai_recommendation_score' => [
                    'stability_score' => '7.2',
                    'growth_potential' => '9.8',
                    'liquidity_rating' => '6.5'
                ],
                'success_rate' => 89.75,
                'color_scheme' => '#dc2626',
                'badges' => ['High Yield', 'VIP'],
                'sort_order' => 3,
                'featured' => true,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Weekly Returns Plan',
                'slug' => 'weekly-returns-plan',
                'description' => 'Receive your profits weekly instead of daily. Perfect for investors who prefer less frequent but larger payouts.',
                'features' => [
                    'Weekly profit payments',
                    'Higher per-payment amounts',
                    'Flexible investment terms',
                ],
                'min_amount' => 500.00,
                'max_amount' => 5000.00,
                'interest_rate' => 8.5,
                'interest_type' => 'fixed',
                'return_type' => 'weekly',
                'duration_days' => 84,
                'principal_return' => 'yes',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 15.00,
                'partial_withdrawal_allowed' => true,
                'early_withdrawal_fee' => 3.00,
                'max_investors' => 300,
                'total_cap' => 1000000.00,
                'risk_level' => 'medium',
                'ai_recommendation_score' => [
                    'stability_score' => '8.5',
                    'growth_potential' => '8.2',
                    'liquidity_rating' => '7.8'
                ],
                'success_rate' => 93.40,
                'color_scheme' => '#f59e0b',
                'badges' => ['Weekly Payments'],
                'sort_order' => 4,
                'featured' => false,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Long Term Investment',
                'slug' => 'long-term-investment',
                'description' => 'For patient investors who want maximum returns over an extended period. Lock in your investment for higher yields.',
                'features' => [
                    'Highest interest rates',
                    'Long-term security',
                    'Compound growth benefits',
                ],
                'min_amount' => 2000.00,
                'max_amount' => 50000.00,
                'interest_rate' => 15.0,
                'interest_type' => 'compound',
                'return_type' => 'monthly',
                'duration_days' => 365,
                'principal_return' => 'after_maturity',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 100.00,
                'partial_withdrawal_allowed' => false,
                'early_withdrawal_fee' => 15.00,
                'max_investors' => 50,
                'total_cap' => 10000000.00,
                'risk_level' => 'medium',
                'ai_recommendation_score' => [
                    'stability_score' => '9.0',
                    'growth_potential' => '9.5',
                    'liquidity_rating' => '5.0'
                ],
                'success_rate' => 96.80,
                'color_scheme' => '#7c3aed',
                'badges' => ['Long Term', 'High Yield', 'Exclusive'],
                'sort_order' => 5,
                'featured' => false,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Enterprise Plan',
                'slug' => 'enterprise-plan',
                'description' => 'Designed for institutional investors and high-net-worth individuals. Maximum investment capacity with premium services.',
                'features' => [
                    'Institutional-grade security',
                    'Dedicated relationship manager',
                    'Custom investment strategies',
                ],
                'min_amount' => 100000.00,
                'max_amount' => 1000000.00,
                'interest_rate' => 3.2,
                'interest_type' => 'compound',
                'return_type' => 'weekly',
                'duration_days' => 180,
                'principal_return' => 'after_maturity',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 75.00,
                'partial_withdrawal_allowed' => true,
                'early_withdrawal_fee' => 8.00,
                'max_investors' => 25,
                'total_cap' => 50000000.00,
                'risk_level' => 'medium',
                'ai_recommendation_score' => [
                    'stability_score' => '9.5',
                    'growth_potential' => '8.8',
                    'liquidity_rating' => '7.0'
                ],
                'success_rate' => 97.90,
                'color_scheme' => '#1f2937',
                'badges' => ['Enterprise', 'Institutional', 'Premium'],
                'sort_order' => 7,
                'featured' => true,
                'status' => 'active',
                'starts_at' => null,
                'ends_at' => null,
            ],
            [
                'name' => 'Coming Soon Plan',
                'slug' => 'coming-soon-plan',
                'description' => 'An exciting new investment opportunity launching soon. Revolutionary approach to cryptocurrency and DeFi investments.',
                'features' => [
                    'Revolutionary DeFi integration',
                    'AI-powered portfolio management',
                    'Cross-chain investment options',
                ],
                'min_amount' => 1000.00,
                'max_amount' => 25000.00,
                'interest_rate' => 5.5,
                'interest_type' => 'compound',
                'return_type' => 'daily',
                'duration_days' => 45,
                'principal_return' => 'after_maturity',
                'auto_reinvest_available' => true,
                'auto_reinvest_rate' => 40.00,
                'partial_withdrawal_allowed' => false,
                'early_withdrawal_fee' => 12.00,
                'max_investors' => 150,
                'total_cap' => 3000000.00,
                'risk_level' => 'high',
                'ai_recommendation_score' => [
                    'stability_score' => '7.8',
                    'growth_potential' => '9.9',
                    'liquidity_rating' => '6.8'
                ],
                'success_rate' => 0.00,
                'color_scheme' => '#06b6d4',
                'badges' => ['Coming Soon', 'Revolutionary', 'DeFi'],
                'sort_order' => 8,
                'featured' => false,
                'status' => 'coming_soon',
                'starts_at' => now()->addDays(15),
                'ends_at' => null,
            ]
        ];

        foreach ($plans as $planData) {
            InvestmentPlan::create($planData);
        }
    }
}
