<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('uid', 50)->index()->nullable();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('wallet_address')->nullable()->unique()->index();
            $table->string('wallet_type', 20)->default('metamask')->index();
            $table->string('password');
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->enum('role', ['user', 'admin', 'moderator'])->default('user');
            $table->enum('status', ['active', 'suspended', 'pending', 'banned'])->default('active');
            $table->enum('kyc_status', ['pending', 'reviewing', 'approved', 'rejected'])->default('pending');
            $table->string('avatar')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->boolean('is_admin')->default(false);
            $table->string('referral_code')->unique()->nullable();
            $table->unsignedBigInteger('referred_by')->nullable();
            $table->integer('total_referrals')->default(0);
            $table->integer('active_referrals')->default(0);
            $table->json('ai_risk_profile')->nullable();
            $table->enum('risk_tolerance', ['conservative', 'moderate', 'aggressive'])->default('moderate');
            $table->decimal('ai_score', 5, 2)->default(0);
            $table->string('nonce', 64)->nullable();
            $table->timestamp('nonce_expires_at')->nullable();
            $table->rememberToken();
            $table->timestamps();

            $table->foreign('referred_by')->references('id')->on('users')->onDelete('set null');
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
